#!/bin/sh

PERL=5.26.1
FREETZ=$HOME/freetz-trunk

cd $HOME/
mkdir perl_install

wget https://github.com/arsv/perl-cross/releases/download/1.1.8/perl-cross-1.1.8.tar.gz
wget http://www.cpan.org/src/5.0/perl-${PERL}.tar.gz
tar xfz perl-${PERL}.tar.gz

wget http://search.cpan.org/CPAN/authors/id/I/IS/ISHIGAKI/JSON-2.94.tar.gz
tar xfz JSON-2.94.tar.gz
mv JSON-2.94 perl-${PERL}/cpan/JSON
cp JSON_Makefile.PL perl-${PERL}/cpan/JSON/Makefile.PL

if [ -n "$(grep '^FREETZ_OPENSSL_VERSION_1=y' ${FREETZ}/.config)" ] ; then
	wget http://search.cpan.org/CPAN/authors/id/M/MI/MIKEM/Net-SSLeay-1.82.tar.gz
	wget http://search.cpan.org/CPAN/authors/id/S/SU/SULLR/IO-Socket-SSL-2.052.tar.gz
	tar xfz Net-SSLeay-1.82.tar.gz
	tar xfz IO-Socket-SSL-2.052.tar.gz
	mv Net-SSLeay-1.82 perl-${PERL}/cpan/Net-SSLeay
	mv IO-Socket-SSL-2.052 perl-${PERL}/cpan/IO-Socket-SSL
	cp Net-SSLeay_Makefile.PL perl-${PERL}/cpan/Net-SSLeay/Makefile.PL
	cp IO-Socket-SSL_Makefile.PL perl-${PERL}/cpan/IO-Socket-SSL/Makefile.PL
fi

if [ -n "$(grep '^FREETZ_PACKAGE_SQLITE=y' ${FREETZ}/.config)" ] ; then
	wget http://search.cpan.org/CPAN/authors/id/T/TI/TIMB/DBI-1.637.tar.gz
	wget http://search.cpan.org/CPAN/authors/id/I/IS/ISHIGAKI/DBD-SQLite-1.54.tar.gz
	tar xfz DBI-1.637.tar.gz
	tar xfz DBD-SQLite-1.54.tar.gz
	mv DBI-1.637 perl-${PERL}/cpan/DBI
	mv DBD-SQLite-1.54 perl-${PERL}/cpan/DBD-SQLite
	cp DBD-SQLite_Makefile.PL perl-${PERL}/cpan/DBD-SQLite/Makefile.PL
	cat perl-${PERL}/cpan/DBI/Driver.xst | sed 's/~DRIVER~/SQLite/g' > perl-${PERL}/cpan/DBD-SQLite/SQLite.xsi
fi

cd perl-${PERL}
tar --strip-components=1 -zxf ../perl-cross-1.1.8.tar.gz

export PATH=$FREETZ/toolchain/target/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:
./configure --prefix=/var/InternerSpeicher/opt --target=mips-linux --target-tools-prefix=mips-linux- --mode=cross
make
make modules-reset
make modules
make DESTDIR=$HOME/perl_install install

cd $HOME/perl_install
rm -rf var/InternerSpeicher/opt/share
tar cfz $HOME/freetz_perl-${PERL}.tgz var/
cd $HOME/
