#!/bin/sh

PERL=5.29.0
PERLCROSS=1.2
JSON=2.97001
SSLeay=1.85
SOCKETSSL=2.059
DBI=1.641
SQLITE=1.58

FREETZ=$HOME/freetz-trunk
INSTALLDIR=/var/InternerSpeicher/opt

cd $HOME/
if [ ! -d perl_install ] ; then
	mkdir perl_install
else
	rm -rf perl_install/*
fi

if [ ! -f perl-cross-${PERLCROSS}.tar.gz ] ; then
	wget https://github.com/arsv/perl-cross/releases/download/${PERLCROSS}/perl-cross-${PERLCROSS}.tar.gz
fi
if [ ! -f perl-${PERL}.tar.gz ] ; then
	wget http://www.cpan.org/src/5.0/perl-${PERL}.tar.gz
fi
tar xfz perl-${PERL}.tar.gz

if [ ! -f JSON-${JSON}.tar.gz ] ; then
	wget http://search.cpan.org/CPAN/authors/id/I/IS/ISHIGAKI/JSON-${JSON}.tar.gz
fi
tar xfz JSON-${JSON}.tar.gz
mv JSON-${JSON} perl-${PERL}/cpan/JSON
cp JSON_Makefile.PL perl-${PERL}/cpan/JSON/Makefile.PL

if [ -n "$(grep '^FREETZ_OPENSSL_VERSION_1=y' ${FREETZ}/.config)" ] ; then
	if [ ! -f Net-SSLeay-${SSLeay}.tar.gz ] ; then
		wget http://search.cpan.org/CPAN/authors/id/M/MI/MIKEM/Net-SSLeay-${SSLeay}.tar.gz
	fi
	if [ ! -f IO-Socket-SSL-${SOCKETSSL}.tar.gz ] ; then
		wget http://search.cpan.org/CPAN/authors/id/S/SU/SULLR/IO-Socket-SSL-${SOCKETSSL}.tar.gz
	fi
	tar xfz Net-SSLeay-${SSLeay}.tar.gz
	tar xfz IO-Socket-SSL-${SOCKETSSL}.tar.gz
	mv Net-SSLeay-${SSLeay} perl-${PERL}/cpan/Net-SSLeay
	mv IO-Socket-SSL-${SOCKETSSL} perl-${PERL}/cpan/IO-Socket-SSL
	cp Net-SSLeay_Makefile.PL perl-${PERL}/cpan/Net-SSLeay/Makefile.PL
	cp IO-Socket-SSL_Makefile.PL perl-${PERL}/cpan/IO-Socket-SSL/Makefile.PL
fi

if [ -n "$(grep '^FREETZ_PACKAGE_SQLITE=y' ${FREETZ}/.config)" ] ; then
	if [ ! -f DBI-${DBI}.tar.gz ] ; then
		wget http://search.cpan.org/CPAN/authors/id/T/TI/TIMB/DBI-${DBI}.tar.gz
	fi
	if [ ! -f DBD-SQLite-${SQLITE}.tar.gz ] ; then
		wget http://search.cpan.org/CPAN/authors/id/I/IS/ISHIGAKI/DBD-SQLite-${SQLITE}.tar.gz
	fi
	tar xfz DBI-${DBI}.tar.gz
	tar xfz DBD-SQLite-${SQLITE}.tar.gz
	mv DBI-${DBI} perl-${PERL}/cpan/DBI
	mv DBD-SQLite-${SQLITE} perl-${PERL}/cpan/DBD-SQLite
	cp DBD-SQLite_Makefile.PL perl-${PERL}/cpan/DBD-SQLite/Makefile.PL
	cat perl-${PERL}/cpan/DBI/Driver.xst | sed 's/~DRIVER~/SQLite/g' > perl-${PERL}/cpan/DBD-SQLite/SQLite.xsi
fi

cd perl-${PERL}
tar --strip-components=1 -zxf ../perl-cross-${PERLCROSS}.tar.gz

export PATH=$FREETZ/toolchain/target/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:
./configure --prefix=${INSTALLDIR} --target=mips-linux --target-tools-prefix=mips-linux- --mode=cross
make
make DESTDIR=$HOME/perl_install install

cd $HOME/perl_install
rm -rf ${INSTALLDIR#/}/share
tar cfz $HOME/freetz_perl-${PERL}.tgz ${INSTALLDIR#/}
cd $HOME/
